﻿
# Ceci est un commentaire :pas lu par l'interpréteur

def tension(R, i):
    """
    Ceci est l'aide du programme.
        Entrée : R résistance du dipole
                 i intensité le traversant
        Sortie : la tension aux bornes du dipole
    """
    return R*i


def temps_parcourt(l, v):
    return l/v


# Puissance : **
# Le nombre pi : np.pi, une fois chargée la bibliothèque numpy sous l'alias np comme ci-dessous

import numpy as np

def volume_boule(R):
    """ Entrée : R le rayon d'une boule
        Sortie : le volume de cette boule
        """
    return 4/3*np.pi*R**3


def masse_boule(R, rho):
    """ Entrée : R rayon d'une boule en mètres
                 rho : masse volumique d en kg.m**-3
        Sortie : masse de cette boule en kg
        """
    return rho * volume_boule(R)


g=9.81 # On crée une variable globale g, qui contient la valeur 9.81


def poids(R, rho):
    """ Entrée : R rayon d'une boule en mètres
                 rho : masse volumique d'icelle en kg.m**-3
        Sortie : poids de cette boule en Newton
        """

    return masse_boule(R, rho) * g



# Maintenant, on ne prend plus une boule pleine mais une sphère creuse. Le but est de voir si elle flotte.

def masse_sphere(R, e, rho):
    """ Masse d'une sphère d'épaisseur e de rayon R de masse volumique rho."""
    return 4*np.pi*R**2 * rho * e

def poids_sphere(R,e,rho):
    return g*masse_sphere(R,e,rho)

rho_eau=1000

def archimede(R):
    return volume_boule(R) * rho_eau * g

def acceleration_sphere(R,e,rho):
    return (archimede(R) - poids_sphere(R,e,rho) ) / masse_sphere(R,e,rho)


# Testons si la sphère flotte.
# On va utiliser un "if"
def flotte(r, e, ro):
    if acceleration_sphere(r, e, ro) >0 :
        return True
    else:
        return False


# Remarque (pas vitale)
# Si vous tenez à faire de la littérature (en terme technique, créons une interface utilisateur) à partir du programme flotte
def fonction_inutile(r,e,rho):
    if flotte(r,e, rho):
        print("La sphère flotte")
    else:
        print("La sphère ne flotte pas")

